/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.drg.clasificator.util;

import com.sun.management.GarbageCollectionNotificationInfo;
import cz.drg.clasificator.util.Constants;
import cz.drg.clasificator.util.OutputHelper;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

/**
 *
 * @author jiras
 */
public class JvmMonitor {

    public void registerForMemUsageChanges() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
            listenForGarbageCollectionOn(garbageCollectorMXBean);
        }

    }

    private void listenForGarbageCollectionOn(GarbageCollectorMXBean garbageCollectorMXBean) {
        NotificationEmitter notificationEmitter = (NotificationEmitter) garbageCollectorMXBean;
        GarbageListener listener = new GarbageListener();
        notificationEmitter.addNotificationListener(listener, null, null);
    }

}

class GarbageListener implements NotificationListener {

    private static final int MB = 1024 * 1024;
    private static final double MAX_MEMORY_USAGE = 0.8;

    private final Runtime runtime = Runtime.getRuntime();

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals(GarbageCollectionNotificationInfo.GARBAGE_COLLECTION_NOTIFICATION)) {
            
            double currentTotalMem = getTotalMemory();
            double currentUsedMem = currentTotalMem - getFreeMemory();
            double currentMemoryUsage = currentUsedMem / currentTotalMem;
            
            if(currentMemoryUsage > MAX_MEMORY_USAGE){
                OutputHelper.dualLog(String.format(Constants.ERR_EXCEEDED_MAX_MEMORY_USAGE, currentMemoryUsage*100, currentUsedMem, currentTotalMem));
                shutdown();
            }
        }
    }
    
    private void shutdown(){
        OutputHelper.dualLog("Program will shutdown.");
        System.exit(0);
    }
    
    private double getFreeMemory() {
        return runtime.freeMemory() / MB;
    }

    private double getTotalMemory() {
        return runtime.totalMemory() / MB;
    }
}
